( function( $ ){
    var load = function( ){
        $( '#dm-add-new-api-key' ).on( 'click', addNewKey );
        $( '#dm-api-keys tbody [data-remove]' ).on( 'click', removeKey );
    }

    var addNewKey = function( ){
        var markup = '<tr>' +
                     '<td class="left">' +
                     '<input type="text" name="api-key-name[]" placeholder="Key Name" />' +
                     '</td>' +
                     '<td class="right">' +
                     '<input type="text" name="api-key-value[]" placeholder="Key Value" />' +
                     '</td>' +
                     '<td class="control right">' +
                     '<a data-remove>' +
                     '<span class="dashicons dashicons-no"></span>' +
                     '</a>' +
                     '</td>' +
                     '</tr>';
        var $row = $( markup );
        var $table = $( '#dm-api-keys tbody' );
        var $keys = $table.find( '[name]' );
        
        if( $keys.length <= 0 )
            $table.find( 'tr' ).eq( 0 ).remove( );

        $row.find( '[data-remove]' ).on( 'click', removeKey );
        $table.find( 'tr' ).last( ).before( $row );
        $row.find( 'input' ).first( ).focus( );
    }

    var removeKey = function( ){
        var $btn = $( this );
        var $tr = $btn.parents( 'tr' );
        var name = $tr.find( '[name^=api-key-name]' ).val( );
        var key = $tr.find( '[name^=api-key-value]' ).val( );
        var msg = '';
        if( name.length > 0 ){
            msg = 'Delete key "' + name + '"';
            if( key.length > 0 )
                msg += ' (' + key + ')';
            msg += '?';
        } else if( key.length > 0 ){
            msg = 'Delete the key "' + key + '"?';
        }

        if( msg.length == 0 || confirm( msg ) ){
            if( $tr.siblings( ).length == 1 ){
                var $row = $( '<tr>' +
                              '<td class="heading center" colspan="3">' +
                              'No API Keys Found' +
                              '</td>' +
                              '</tr>' );
                $tr.siblings( ).last( ).before( $row );
            }
            $tr.remove( );
        }
    }

    $( document ).ready( load );
} )( jQuery );