<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ACA_WC_Column_Product_BackordersAllowed extends AC_Column_Meta
	implements ACP_Column_SortingInterface, ACP_Column_EditingInterface, ACP_Column_FilteringInterface {

	public function __construct() {
		$this->set_type( 'column-wc-backorders_allowed' );
		$this->set_label( __( 'Backorders Allowed', 'codepress-admin-columns' ) );
		$this->set_group( 'woocommerce' );
	}

	// Meta

	public function get_meta_key() {
		return '_backorders';
	}

	// Display

	public function get_value( $post_id ) {

		switch ( $this->get_raw_value( $post_id ) ) {
			case 'no' :
				$value = ac_helper()->icon->no( __( 'No' ) );

				break;
			case 'yes' :
				$value = ac_helper()->icon->yes( __( 'Yes' ) );

				break;
			case 'notify' :
				$icon_email = ac_helper()->icon->dashicon( array( 'icon' => 'email-alt' ) );
				$value = ac_helper()->html->tooltip( ac_helper()->icon->yes() . $icon_email, __( 'Yes, but notify customer', 'woocommerce' ) );

				break;
			default :
				$value = $this->get_empty_char();
		}

		return $value;
	}

	public function get_raw_value( $post_id ) {
		return $this->get_backorders( $post_id );
	}

	// Pro

	public function editing() {
		return new ACA_WC_Editing_Product_BackordersAllowed( $this );
	}

	public function sorting() {
		return new ACA_WC_Sorting_Product_BackordersAllowed( $this );
	}

	public function filtering() {
		return new ACA_WC_Filtering_Product_BackordersAllowed( $this );
	}

	// Common

	public function get_backorders( $id ) {
		return wc_get_product( $id )->get_backorders();
	}

}
