<?php
    if ( apply_filters( 'woocommerce_show_page_title', true ) ){
        DM( )->theme->wrapTheTitle( 'h1' );
    }
    do_action( 'woocommerce_archive_description' );

    echo '<div class="row">';
    foreach( get_terms( 'dm_product_type', array( 'parent' => 0, 'orderby' => 'term_order' ) ) as $term ){
        $termLink = get_term_link( $term, 'dm_product_type' );
        echo '<div class="col-sm-12 product-classification">';
        echo '<h3 class="classification-title">';
        echo '<a href="' . $termLink . '" class="see-all btn btn-default">See All</a>';
        echo '<a href="' . $termLink . '">' . $term->name . '</a>';
        echo '</h3>';
        echo '<div class="product-type-products">';
        echo '<div class="row">';
        $query = DM( )->productTypes->getProducts( $term->slug, 4 );
        while( $query->have_posts( ) ){
            $query->the_post( );

            echo '<div class="col-xs-6 col-sm-4 col-md-3">';
            get_template_part( 'part-product-preview' );
            echo '</div>';
        }
        wp_reset_postdata( );

        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
    echo '</div>';
