<?php
/**
 * Product quantity inputs
 *
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

?>
<label class="input-group quantity">
  <span class="input-group-addon" id="basic-addon1">Qty</span>
  <input
    type="number"
    class="form-control"
    step="<?php echo esc_attr( $step ); ?>"
    <?php if ( is_numeric( $min_value ) ) : ?>
    min="<?php echo esc_attr( $min_value ); ?>"
    <?php endif; ?>
    <?php if ( is_numeric( $max_value ) ) : ?>
    max="<?php echo esc_attr( $max_value ); ?>"
    <?php endif; ?>
    name="<?php echo esc_attr( $input_name ); ?>"
    value="<?php echo esc_attr( $input_value ); ?>"
    title="<?php _ex( 'Quantity', 'Product quantity input tooltip', 'woocommerce' ) ?>"
    size="4"
    aria-describedby="basic-addon1" />
</label>
