<?php
    /**
     *  Module Name: DM API Keys Manager
     *  Version:     v1.0
     *  Description: A simple UI for managing API Keys that are needed by the site.
     *  Author:      Distill Mill LLC
     *  Author URI:  http://distillmill.com
     */

    class DM_APIKeys{
        private static $instance;
        private $keys = array( );

        public static function getInstance( ){
            if( !isset( self::$instance ) ){
                self::$instance = new self( );
                self::getInstance( )->init( );
            }

            return self::$instance;
        }

        public static function call( $method ){
            return array( self::getInstance( ), $method );
        }

        public function init( ){
            add_action( 'admin_enqueue_scripts', self::call( 'enqueue' ) );

            if( is_admin( ) )
                DM( )->admin->addTabMetaBox( 'API Keys', array( 'general_settings' ), AdminRenderer( DM_UTILS_DIR . '_modules/dm-api-keys/manage-api-keys.php', $this ), self::call( 'saveAPIKeys' ), 'no-pad' );
        }

        public function enqueue( $hook ){
            if( $hook == DM( )->admin->menu ){
                wp_enqueue_script( 'dm-api-keys-manager', DM_UTILS_URL . '_modules/dm-api-keys/api-key-manager.min.js' );
            }
        }

        public function saveAPIKeys( $tab ){
            $this->keys = array( );
            if( isset( $_POST[ 'api-key-name' ] ) ){
                foreach( $_POST[ 'api-key-name' ] as $index=>$name ){
                    if( $name && isset( $_POST[ 'api-key-value' ][ $index ] ) && $_POST[ 'api-key-value' ][ $index ] )
                        $this->keys[ $name ] = $_POST[ 'api-key-value' ][ $index ];
                }
            }
            update_option( 'dm-api-keys', $this->keys );
        }

        public function getAPIKey( $name ){
            $keys = $this->getAPIKeys( );
            if( $keys && isset( $keys[ $name ] ) )
                return $keys[ $name ];
            return null;
        }

        public function getAPIKeys( ){
            if( !$this->keys )
                $this->keys = get_option( 'dm-api-keys' );
            return ( $this->keys ? $this->keys : array( ) );
        }
    }

    add_action( 'dm_init', 'DM_APIKeys::getInstance' );
