<?php
    /**
     *  Module Name: DM Paged Query
     *  Version:     v1.0
     *  Description: Simple utility that extends the WP_Query class with some useful paging methods.
     *  Author:      Distill Mill LLC
     *  Author URI:  http://distillmill.com
     */

    class DM_PagedQuery extends WP_Query{
        public function __construct( $args ){
            $args[ 'paged' ] = $this->getPageNumber( );
            if( !$args[ 'posts_per_page' ] ) $args[ 'posts_per_page' ] = get_option( 'posts_per_page' );  // Just to make sure
            parent::__construct( $args );
        }

        public static function getPageNumber( ){
            return ( get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1 );
        }

        public static function getNumPages( ){
            return $GLOBALS[ 'wp_query' ]->max_num_pages;
        }

        public static function getPagination( ){
            // Filters should return true if they handle the pagination.
            if( apply_filters( 'dm_show_pagination', self::getNumPages( ) > 1, self::getPageNumber( ) ) ){
                next_posts_link( '&lt; Older posts' );
                echo ' Page ' . self::getPageNumber( ) . ' ';
                previous_posts_link( 'Newer posts &gt;' );
            }
        }
    }