<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

?>

<?php
    global $product;
    /**
     * woocommerce_before_single_product hook
     *
     * @hooked wc_print_notices - 10
     */

    do_action( 'woocommerce_before_single_product' );

    if ( post_password_required() ) {
        echo get_the_password_form();
        return;
    }
?>
<div class="row">
    <div class="col-sm-12">
        <div itemscope id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
<?php
    /* 20180205 - no product gallery per Davids request
    $images = array( );
    if( is_page( ) || is_single( ) || DM( )->safeCall( 'is_product' ) || $post->post_type === 'product' ){
        if( DM( )->safeCall( 'is_product' ) || $post->post_type === 'product' ){
            $pf = new WC_Product_Factory;
            $product = $pf->get_product( $post->ID );
            foreach( $product->get_gallery_attachment_ids( ) as $image ){
                $images[ ] = array(
                    DM( )->theme->sizeImage( wp_get_attachment_url( $image ), null, 570 ),
                    DM( )->theme->sizeImage( wp_get_attachment_url( $image ), 50, 50 ),
                );
            }
        }
        if( !$images && DM( )->getField( 'gallery' ) ){
            foreach( DM( )->getField( 'gallery', $product->ID ) as $image ){
                $images[ ] = array(
                    DM( )->theme->sizeImage( $image[ 'url' ], null, 570 ),
                    DM( )->theme->sizeImage( $image[ 'url' ], 50, 50 )
                );
            }
        }
        if( !$images ) $images[ ] = array( DM( )->theme->sizeImage( get_post_thumbnail_url( ), null, 570 ) );
    } elseif( DM( )->getField( 'placeholder_images', 'option' ) ){
        $placeholders = DM( )->getField( 'placeholder_images', 'option' );
        $default = null;
        $obj = get_queried_object( );
        foreach( $placeholders as $placeholder ){
            if( $placeholder[ 'post_type' ] == 'default' )
                $default = $placeholder[ 'image' ];
            elseif( $placeholder[ 'post_type' ] == $obj->slug ){
                $images[ ] = array( DM( )->theme->sizeImage( $placeholder[ 'image' ][ 'url' ], null, 570 ) );
                $default = null;
                break;
            }
        }
        if( $default )
            $images[ ] = array( DM( )->theme->sizeImage( $image[ 'url' ], null, 570 ) );
    }
    if( $images ):
?>
            <div id="product-carousel" class="carousel slide<?php if( count( $images ) <= 1 ) echo ' single-slide'; ?>" data-ride="carousel">
                <!-- Indicators -->
                <?php if( count( $images ) > 1 ): ?>
                <div class="carousel-indicators-container hidden">
                    <div class="container">
                        <ol class="carousel-indicators">
                            <?php
                                for( $i=0; $i<count( $images ); $i++ ){
                                    echo '<li data-target="#product-carousel" data-slide-to="' . $i . '"';
                                    if( $i == 0 )
                                        echo ' class="active"';
                                    echo '>';
                                    echo '<img src="' . $images[ $i ][ 1 ] . '" />';
                                    echo '</li>';
                                }
                            ?>
                        </ol>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <?php
                        for( $i=0; $i<count( $images ); $i++ ){
                            echo '<div class="item';
                            if( $i == 0 )
                                echo ' active';
                            echo '">';
                            echo '<img src="' . $images[ $i ][ 0 ] . '">';
                            echo '</div>';
                        }
                    ?>
                </div>

                <?php if( count( $images ) > 1 ): ?>
                <!-- Controls -->
                <div class="carousel-controls hidden">
                    <a class="left carousel-control" href="#product-carousel" role="button" data-slide="prev">
                        <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="right carousel-control" href="#product-carousel" role="button" data-slide="next">
                        <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
                <?php endif; ?>
            </div>
<?php endif; // $images */ ?>
<?php
    /**
     * woocommerce_before_single_product_summary hook
     *
     * @hooked woocommerce_show_product_sale_flash - 10
     * @hooked woocommerce_show_product_images - 20
     */
    do_action( 'woocommerce_before_single_product_summary' );
?>

            <div class="summary entry-summary" style="margin-bottom:30px">

                <?php
                    /**
                     * woocommerce_single_product_summary hook
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     */
                    do_action( 'woocommerce_single_product_summary' );
                    the_content();
                ?>

            </div><!-- .summary -->
        </div>
        <?php do_action( 'woocommerce_after_single_product' ); ?>
    </div>
    <div class="col-xs-6">
        <?php
            woocommerce_template_single_add_to_cart( );
            if( !$product->get_price_html( ) ){
                echo '<p class="price"><span>Price Not Available</span></p>';
            }
        ?>
    </div>
    <div class="col-xs-6 text-right">
        <style type="text/css">
            .woocommerce-Price-amount.amount{
                font-size:40px;
                line-height:1;
            }
            .languages{
                margin-bottom:15px;
            }
        </style>
        <?php woocommerce_template_single_price( ); ?>
    </div>
</div>