<?php
// enqueue styles and scripts
function dm_enqueue_scripts() {
    wp_enqueue_style( 'bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css', false, '3', 'all' );
    wp_enqueue_style( 'app', DM()->getTemplateURL() . '/css/app.min.css', false, '1.00' );

    wp_deregister_script('jquery');
    wp_register_script('jquery', '//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js', false, null);
    wp_enqueue_script('modernizr', DM()->getTemplateURL() . '/js/modernizr.js', array('jquery'), '1', false);
    wp_enqueue_script('jquery');

    wp_enqueue_script('bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js', array('jquery'), '1', true);
    wp_enqueue_script('app', DM()->getTemplateURL() . '/js/app.min.js', array('jquery'), '1.00', true);
}
add_action( 'wp_enqueue_scripts', 'dm_enqueue_scripts' );

function dm_enqueue_admin_scripts() {
    wp_enqueue_script('app', DM()->getTemplateURL() . '/js/admin.min.js', array('jquery'), '1.00', true);
}
add_action( 'admin_enqueue_scripts', 'dm_enqueue_admin_scripts' );

// Add custom styles to editor
add_editor_style('css/editor-style.min.css');

// Add Post Thumbnails on Posts and Pages
add_theme_support( 'post-thumbnails', array( 'post','page') );

register_nav_menus( array(
    'header_navigation' => 'Header Navigation',
    'footer_navigation' => 'Footer Navigation',
) );


//  Hide Admin Bar for those who cannot edit posts: Roles below editor.
function show_hide_admin_bar($content) {
    return ( !current_user_can("edit_posts") ) ? false : $content;
}
add_filter( 'show_admin_bar' , 'show_hide_admin_bar');


// Add Placeholder text to Gravity Forms
add_action("gform_field_standard_settings", "my_standard_settings", 10, 2);
function my_standard_settings($position, $form_id){
    // Create settings on position 25 (right after Field Label)
    if($position == 25){
?>
    <li class="admin_label_setting field_setting" style="display: list-item; ">
    <label for="field_placeholder">Placeholder Text
    <!-- Tooltip to help users understand what this field does -->
    <a href="javascript:void(0);" class="tooltip tooltip_form_field_placeholder" tooltip="&lt;h6&gt;Placeholder&lt;/h6&gt;Enter the placeholder/default text for this field.">(?)</a>
    </label>
    <input type="text" id="field_placeholder" class="fieldwidth-3" size="35" onkeyup="SetFieldProperty('placeholder', this.value);">
    </li>
<?php
    }
}

function woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'woocommerce_support' );

require_once( 'includes/dm-theme.php' );
require_once( 'includes/dm-product-type.php' );