<?php
    // This should be for general theme code...
    if( class_exists( 'DM_Theme' ) ){
        class Theme extends DM_Theme{
            public function __construct( ){
                DM( )->registerTheme( 'theme', $this );

                add_filter( 'dm_main_title', $this->call( 'addControlsToTitle' ) );
                add_action( 'add_meta_boxes', $this->call( 'addProductSettings' ) );

                add_filter( 'wc_get_template_part', $this->call( 'getWooCommerceTemplate' ), 10, 3 );
                add_filter( 'woocommerce_product_single_add_to_cart_text', $this->call( 'filterAddToCartText' ) );
                add_action( 'woocommerce_after_single_product_summary', $this->call( 'showSamples' ) );
                add_filter( 'wp_nav_menu_objects', $this->call( 'buildPrimaryNavigationMenu' ), 10, 2 );
                add_filter( 'dm_show_pagination', $this->call( 'showPagination' ), 10, 2 );
                add_action( 'woocommerce_single_product_summary', $this->call( 'showProductLanguages' ), 6 );
                // Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
                add_filter( 'woocommerce_add_to_cart_fragments', $this->call( 'updateCartWidget' ) );


                remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
                remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
                remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
            }

            public function addControlsToTitle( $title ){
                if( is_user_logged_in( ) ){
                    $title .= '<a href="' . get_edit_post_link( ) . '" class="edit-post-link glyphicon glyphicon-edit" title="Edit"><span class="sr-only">Edit</span></a>';
                    $title .= '<a href="' . admin_url( ) . '" class="edit-post-link glyphicon glyphicon-dashboard" title="Dashboard"><span class="sr-only">Dashboard</span></a>';
                }
                return $title;
            }

            public function addProductSettings( ){
                DM( )->admin->addMetaBox( 'dm-product-settings', 'Product Configuration', $this->call( 'displayMetaBox' ), 'dm-meta-box no-pad', 'product', 'normal', 'high' );
            }

            public function buildPrimaryNavigationMenu( $items, $args ){
                if( $args->theme_location == 'header_navigation' ){
                    $newItems = array( );
                    $parents = array( );
                    $type = null;

                    if( DM( )->safeCall( 'is_product' ) )
                        $type = DM( )->productTypes->getCurrentType( );

                    // echo '<div style="position:relative;z-index:100;top:250px;">';
                    // vd( $type );
                    // echo '</div>';

                    foreach( $items as $item ){
                        $parents[ $item->ID ] = count( $newItems );
                        $newItems[ ] = $item;

                        if( $item->object == 'dm_product_type' && $item->menu_item_parent != 0 ){
                            $products = DM( )->productTypes->getProducts( $item->object_id, 4, null, 'term_id' );

                            if( $type->term_id == $item->object_id ){
                                $newItems[ $parents[ $item->menu_item_parent ] ]->classes[ ] = 'current-menu-ancestor';
                                $newItems[ $parents[ $item->ID ] ]->classes[ ] = 'current-menu-item';
                            }

                            foreach( $products->posts as $product ){
                                $product->menu_item_parent = $item->ID;
                                $product->url = get_permalink( $product->ID );
                                $product->title = $product->post_title;
                                $product->object_id = $product->ID;
                                $product->classes = array( );

                                if( DM( )->safeCall( 'is_product' ) && get_queried_object_id( ) == $product->ID )
                                    $product->classes[ ] = 'current-menu-item';

                                $newItems[ ] = $product;
                            }

                            if( $products->have_posts( ) ){
                                $newItems[ $parents[ $item->ID ] ]->classes[ ] = 'menu-item-has-children';
                                
                                $seeAll = (object) array( );
                                $seeAll->menu_item_parent = $item->ID;
                                $seeAll->url = $item->url;
                                $seeAll->title = 'See All';
                                $seeAll->object_id = 0;
                                $seeAll->classes = array( 'see-all' );

                                $newItems[ ] = $seeAll;
                            }
                        }
                    }

                    $items = $newItems;
                }

                return $items;
            }

            public function displayMetaBox( ){
                echo '<table class="dm-settings-table">';
                echo '<tbody>';
                DM( )->productTypes->displayMetaBox( );
                echo '</tbody>';
                echo '</table>';
            }

            public function filterAddToCartText( $text ){
                return __( 'Add To Cart', 'campy-text' );
            }

            public function getCartWidget( ){
                $num = WC( )->cart->cart_contents_count;
                $cart  = '<a id="cart-widget" class="cart-contents';
                if( $num <= 0 )
                    $cart .= ' cart-empty';
                $cart .= '" href="' . wc_get_cart_url( ) . '" ';
                $cart .= 'title="' . __( 'View Your Shopping Cart', 'campy-text' ) . '"';
                $cart .= '>';
                $cart .= '<span class="glyphicon glyphicon-shopping-cart">';
                $cart .= '<span class="sr-only">';
                $cart .= __( 'View Your Shopping Cart', 'campy-text' );
                $cart .= '</span>';
                $cart .= '</span>';
                $cart .= '<span class="cart-qty">';
                $cart .= $num;
                $cart .= '</span>';
                $cart .= '</a>';

                return $cart;
            }

            public function getWooCommerceTemplate( $template, $slug, $name ){
                $temp = locate_template( array( "woo-{$slug}-{$name}.php" ) );
                if( $temp )
                    $template = $temp;
                return $template;
            }

            public function showPagination( $useDefault, $pageNum ){
                // Only want to override the default so don't do anything if the default wasn't activated.
                if( $useDefault ){
                    $numPages = DM_PagedQuery::getNumPages( );
                    $start = max( 1, $pageNum - 2 );
                    $end = min( $numPages + 1, $pageNum + 3 );
                    
                    if( $pageNum > 1 ){
                        $link = get_pagenum_link( $pageNum - 1 );
                        $title = 'Go to page ' . ( $pageNum - 1 ) . ' of ' . $numPages;
                        echo "<a href=\"$link\" class=\"btn prev\" title=\"$title\"><span class=\"glyphicon glyphicon-chevron-left\" aria-hidden=\"true\"></span></a>";
                    }

                    for( $i = $start; $i < $end; $i++ ){
                        if( $i == $pageNum ){
                            $title = 'Page ' . $pageNum;
                            echo "<div class=\"btn current\" title=\"$title\">$i</div>";
                        }
                        else{
                            $link = get_pagenum_link( $i );
                            $title = 'Go to page ' . $i . ' of ' . $numPages;
                            echo "<a href=\"$link\" class=\"btn\" title=\"$title\">$i</a>";
                        }
                    }

                    if( $pageNum < $numPages ){
                        $next = $pageNum + 1;
                        $link = get_pagenum_link( $next );
                        $title = "Go to page {$next} of $numPages";
                        echo "<a href=\"$link\" class=\"btn next\" title=\"$title\"><span class=\"glyphicon glyphicon-chevron-right\" aria-hidden=\"true\"></span></a>";
                    }

                    $useDefault = false;  // Prevent default
                }

                return $useDefault;
            }

            public function showProductLanguages( ){
                $available = DM( )->getField( 'dm-language', 'option' );
                if( !$available ) $available = array( );

                if( $available ){
                    $languages = get_post_meta( get_the_ID( ), 'dm-languages', true );
                    if( !$languages ) $languages = array( );

                    echo '<div class="languages">';
                    foreach( $available as $language ){
                        if( in_array( $language[ 'code' ], $languages ) || ( !$languages && $language[ 'code' ] == 'EN' ) ){
                            echo '<img src="' . DM( )->theme->sizeImage( $language[ 'flag' ][ 'url' ], 20 ) . '"';
                            echo ' title="' . $language[ 'name' ] . '" />';
                        }
                    }
                    echo '</div>';
                }
            }

            public function showSamples( ){
                $samples = DM( )->getField( 'dm-samples' );
                if( $samples ){
                    echo '<div class="product-samples">';
                    echo '<h3>Samples</h3>';
                    foreach( $samples as $sample ){
                        $sample = $sample[ 'file' ];
                        echo '<div class="product-sample">';
                        echo '<a href="' . $sample[ 'url' ] . '" class="btn btn-default" download>Download</a>';
                        echo '<p>' . $sample[ 'title' ] . '</p>';
                        echo '</div>';
                    }
                    echo '</div>';
                }
            }

            public function updateCartWidget( $fragments ) {
                $fragments[ 'a.cart-contents' ] = $this->getCartWidget( );
                
                return $fragments;
            }
        }
    }
