"use strict";var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}(function(){function guidGenerator(){var S4=function S4(){return((1+Math.random())*65536|0).toString(16).substring(1)};return S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4()}function __(text){return typeof ACP_Export.i18n[text]!=="undefined"?ACP_Export.i18n[text]:text}function format(text){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}return text.replace(/{(\d)}/g,function(_,index){return values[Number(index)]})}function confirmLeavePage(){return format("You are currently generating an export file. Leaving the page will cancel this process. Are you sure you want to leave the page?")}jQuery(document).ready(function($){// Add export button to table navigation
var ExportButton=jQuery("<a href=\"#\" class=\"ac-button add-new-h2 ac-button__export\" data-ac-tip=\""+__("Export to CSV")+"\">"+__("Export")+"</a>");jQuery(".tablenav.top .actions:last").append(ExportButton);ac_tooltips($);// Handle export button click callback
ExportButton.click(function(e){e.preventDefault();if(ExportButton.hasClass("disabled")){return}// Disable the export button so it cannot be clicked again
ExportButton.addClass("disabled");// Start export: add popup to check whether the user really wants to leave this page
$(window).on("beforeunload",confirmLeavePage);var NumItemsProcessed="<span class=\"num-processed\">0</span>";var TotalNumItems="<span class=\"total-num-items\">"+ACP_Export.total_num_items+"</span>";var PercentageProcessed="<span class=\"percentage-processed\">0</span>";// Add message
var Message=jQuery("\n        <div class=\"acp-export-notice notice updated\">\n          <div class=\"exporting\">\n            <p>\n              <span class=\"spinner is-active\"></span>\n              "+__("Exporting current list of items.")+"\n              "+format(__("Processed {0} of {1} items ({2}%)."),NumItemsProcessed,TotalNumItems,PercentageProcessed)+"\n            </p>\n          </div>\n          <div class=\"export-completed hidden\">\n            <p>\n              "+format(__("Export completed ({0} items). Your download will start automatically. If this does not happen, you can download the file again: "),TotalNumItems)+"\n              <a href=\"#\" class=\"button button-secondary download\">"+__("Download File")+"</a>\n            </p>\n          </div>\n        </div>\n      ");jQuery(".wp-header-end").after(Message);// Run export
var form=jQuery("#acp-export");var data=form.serializeArray().reduce(function(a,x){return _extends(_defineProperty({},x.name,x.value),a)},{});data["acp_export_action"]="acp_export_listscreen_export";data["acp_export_hash"]=guidGenerator();data["acp_export_counter"]=0;var numRowsProcessed=0;var completeExport=function completeExport(){// As the export is completed, we can now disable popup triggering when trying to
// leave the page
$(window).off("beforeunload",confirmLeavePage);// Enable the export button again
ExportButton.removeClass("disabled")};var runExportJob=function runExportJob(){$.ajax({method:"post",url:window.location.href,data:data,success:function success(result){if(!result.success){// Add a notice
var error="<p>"+__("Something went wrong during exporting. Please try again.")+"</p>";if(result.data){error="<p>"+result.data+"</p>"}Message.html(error);completeExport();return}if(result.data["num_rows_processed"]>0){numRowsProcessed+=result.data["num_rows_processed"];var percentageProcessed=numRowsProcessed/ACP_Export.total_num_items*100;Message.find(".num-processed").html(numRowsProcessed);Message.find(".percentage-processed").html(percentageProcessed.toFixed(0));data["acp_export_counter"]++;runExportJob()}else{completeExport();// Add the download link to the download button and hide progress information
Message.find(".download").attr("href",result.data["download_url"]);Message.find(".exporting").hide();Message.find(".export-completed").show();// Trigger file download in the user's browser
window.location.href=result.data["download_url"];// Make notice dismissible
Message.addClass("is-dismissible");// Notice dismiss button
var DismissButton=jQuery("<button type=\"button\" class=\"notice-dismiss\"><span class=\"screen-reader-text\">"+(commonL10n.dismiss||"")+"</span></button>");Message.append(DismissButton);DismissButton.click(function(e){e.preventDefault();Message.fadeTo(100,0,function(){return Message.slideUp(100,function(){return Message.remove()})})})}}})};runExportJob()})})})();