<?php
    class DM_Admin{
        private static $instance;
        public $menu = null;
        private $utilsTabs = array( );
        private $tabMetaBoxes = array( );

        public static function getInstance( ){
            if( !isset( self::$instance ) ){
                self::$instance = new self;
                self::$instance->load( );
            }

            return self::$instance;
        }

        public static function call( $method ){
            return array( self::getInstance( ), $method );
        }

        public function load( ){
            add_action( 'admin_menu', self::call( 'registerAdmin' ) );
            add_action( 'current_screen', self::call( 'saveAdmin' ) );
            add_action( 'admin_enqueue_scripts', self::call( 'enqueueScripts' ) );
            
            DM( )->registerMember( 'admin', $this );

            $this->addUtilsTab( 'general_settings', 'General Settings', self::call( 'saveSettings' ) );
            $this->addUtilsTab( 'manage_modules', 'Manage Modules', self::call( 'saveModules' ) );

            $this->addTabMetaBox( 'Manage Modules', array( 'manage_modules' ), AdminRenderer( DM_UTILS_DIR . '_dm-utils/admin/pages/manage-modules.php' ), null, 'no-pad' );
        }

        public function enqueueScripts( $hook ){
            if( $hook == $this->menu ){
                wp_enqueue_style( 'dm_admin_css' );
                wp_enqueue_script( 'dm_admin_js' );

                $tabs = DM( )->admin->getUtilsTabs( );
                wp_localize_script( 'dm_admin_js', 'dm_tabs', array_keys( $tabs ) );
            }
        }

        public function registerAdmin( ){
            $this->menu = add_menu_page( 'Distill Mill Utilities', 'DM Utilities', 'administrator', 'dm_utils_admin_pages', AdminRenderer( DM_UTILS_DIR . '_dm-utils/admin/pages/utils.php' ), '', 66 );
        }

        public function saveAdmin( $screen ){
            if( $screen->id == $this->menu
             && isset( $_POST[ 'dm_utils' ] )
             && wp_verify_nonce( $_POST[ 'dm_utils' ], 'update_dm_utils_settings' ) ){
                $tabs = DM( )->admin->getUtilsTabs( );
                $current = $this->getCurrentUtilsTab( );
                if( isset( $tabs[ $current ] ) && $tabs[ $current ][ 'save' ] )
                    call_user_func( $tabs[ $current ][ 'save' ] );
            }
        }

        public function addUtilsTab( $slug, $label, $save=null ){
            $this->utilsTabs[ $slug ] = array(
                'label'  => $label,
                'save'   => $save
            );
        }

        public function addTabMetaBox( $label, $tabs, $renderer, $save=null, $classes='', $context='normal' ){
            if( !isset( $this->tabMetaBoxes[ $context ] ) )
                $this->tabMetaBoxes[ $context ] = array( );

            $this->tabMetaBoxes[ $context ][ ] = array(
                'classes'  => $classes,
                'label'    => $label,
                'renderer' => $renderer,
                'save'     => $save,
                'tabs'     => $tabs
            );
        }

        public function doTabMetaBoxes( $context, $currentTab ){
            if( isset( $this->tabMetaBoxes[ $context ] ) ){
                $screen = get_current_screen( );
                foreach( $this->tabMetaBoxes[ $context ] as $box ){
                    echo '<div class="postbox dm-meta-box no-move';
                    echo ( $box[ 'classes' ] ? ' ' . $box[ 'classes' ] : '' );
                    echo ( !in_array( $currentTab, $box[ 'tabs' ] ) ? ' hidden' : '' ) . '"';
                    echo ' data-for-tab="' . implode( ' ', $box[ 'tabs' ] ) . '">';
                    echo '<h3 class="hndle"><span>' . $box[ 'label' ] . '</span></h3>';
                    echo '<div class="inside">';
                    call_user_func_array( $box[ 'renderer' ], array( $currentTab ) );
                    echo '</div>';
                    echo '</div>';
                }
            }
        }

        public function saveMetaBoxes( $currentTab ){
            foreach( $this->tabMetaBoxes as $context=>$boxes ){
                foreach( $boxes as $box ){
                    if( $box[ 'save' ] && in_array( $currentTab, $box[ 'tabs' ] ) ){
                        call_user_func_array( $box[ 'save' ], array( $currentTab ) );
                    }
                }
            }
        }

        public function getCurrentUtilsTab( ){
            $tabs = DM( )->admin->getUtilsTabs( );
            $keys = array_keys( $tabs );
            return ( isset( $_GET[ 'tab' ] ) && $_GET[ 'tab' ] && isset( $tabs[ $_GET[ 'tab' ] ] ) ? $_GET[ 'tab' ] : $keys[ 0 ] );
        }

        public function saveModules( ){
            // Because modules are loaded so early it is necessary to
            // redirect in order for the changes to affect the page.
            $current = $this->getCurrentUtilsTab( );
            $modules = ( isset( $_POST[ 'enabledModules' ] ) ? $_POST[ 'enabledModules' ] : array( ) );
            $oldModules = get_option( 'dm-enabled-modules' );
            if( !is_array( $oldModules ) )
                $oldModules = array( );
            update_option( 'dm-enabled-modules', $modules );

            foreach( $modules as $module ){
                if( !in_array( $module, $oldModules ) ){
                    include_once( $module );
                    do_action( 'dm_module_enabled', $module );
                }
            }

            wp_redirect( admin_url( 'index.php?page=dm_utils_admin_pages&tab=' . $current ) );
            die;
        }

        public function saveSettings( ){
            $this->saveMetaBoxes( 'general_settings' );
        }

        public function getUtilsTabs( ){
            return $this->utilsTabs;
        }

        // This is a wrapper around WordPress's add_meta_box function. It adds
        // the ability to pass a list of screens to add the meta box to as well
        // as the ability to define a string of custom class names to add to the
        // meta box.
        public function addMetaBox( $id, $title, $callback, $class, $screens, $context = 'advanced', $priority = 'default', $args = null ){
            // This is a helper method that adds the meta box per usual but also
            // registers the appropriate filter to add the requested class to
            // the meta box.
            $filter = new DM_MetaBoxClassFilter( $class );
            if( !is_array( $screens ) )
                $screens = array( $screens );

            foreach( $screens as $screen ){
                add_filter( 'postbox_classes_' . $screen . '_' . $id, array( $filter, 'addClass' ) );
                add_meta_box( $id, $title, $callback, $screen, $context, $priority, $args );
            }
        }
    }

    // This class provides a simple way to dynamically add classes to meta boxes.
    class DM_MetaBoxClassFilter{
        private $class = null;

        public function __construct( $class ){
            $this->class = $class;
        }

        public function addClass( $classes ){
            $classes[ ] = $this->class;
            return $classes;
        }
    }

    // This class provides a simple way to create admin pages without having to
    // create a render function. The construct takes one argument which should
    // be a path that it can include when the page should be rendered.
    class DM_AdminPage{
        private $template = null;

        public function __construct( $template, $vars=null ){
            $this->template = $template;
            $this->vars = $vars;
        }

        public function render( ){
            $vars = $this->vars;
            include( $this->template );
        }
    }

    function AdminRenderer( $template, $vars=null ){
        $renderer = new DM_AdminPage( $template, $vars );
        return array( $renderer, 'render' );
    }

    add_action( 'dm_init', 'DM_Admin::getInstance', 1 );