/**
 *      EDITABLE SELECT BOXES
 *      Well kinda. This just adds a input area after the select if the last
 *      option is selected and adjusts that options value and text with the
 *      value of the input.
 */
( function( $ ){
    var loading = true;

    var load = function( ){
        $( '[data-role=editable-select]' ).on( 'change', showEditField ).each( showEditField );
        loading = false;
    }

    var showEditField = function( e ){
        var field = $( this );
        if( field.prop( 'selectedIndex' ) == field.find( 'option' ).length - 1 ){
            if( field.data( 'edit-field' ) == undefined ){
                var id = 'edit-field-' + Math.floor( Math.random( ) * 1000000 );
                $( '<div style="display:none"><input type="text" id="' + id + '" placeholder="[Custom]" class="edit-select-field" /></div>' ).insertAfter( field );
                var edit = $( '#' + id );
                edit.data( 'owner-field', field );
                edit.on( 'keyup', updateValue );
                field.data( 'edit-field', edit );
            } else
                var edit = field.data( 'edit-field' );
            
            if( loading )
                edit.parent( ).show( );
            else{
                edit.parent( ).slideDown( 250 );
                edit.focus( );
            }
            edit.val( field.val( ) );
        } else if( field.data( 'edit-field' ) != undefined ){
            field.data( 'edit-field' ).parent( ).slideUp( 250 );
        }
    }

    var updateValue = function( e ){
        var edit = $( this );
        var field = edit.data( 'owner-field' );
        var text = edit.val( );
        if( text.length > 0 ) text = '- ' + text + ' -';
        field.find( 'option:selected' ).val( edit.val( ) ).html( text );
    }

    $( document ).ready( load );
} )( jQuery );

/**
 *      BASIC REPEAT AREAS
 *      This will allow the user to create a bunch of text fields which they can
 *      submit. They will also be able to remove unwanted fields.
 */
( function( $ ){
    var load = function( ){
        $( '[data-role=add-repeat-entry]' ).on( 'click', addEntry );
        $( '[data-role=remove-repeat-entry]' ).on( 'click', removeEntry );
    }

    var addEntry = function( ){
        var add = $( this );
        var id = add.attr( 'data-name' );
        var randID = Math.floor( Math.random( ) * 1000000 );
        var editKeys = $( '#' + id + '_repeat' ).attr( 'data-edit-keys' );
        editKeys = ( editKeys != undefined ? editKeys.toLowerCase( ) == 'true' : false );
        var entry  = '<div id="' + id + '_entry_' + randID + '" class="repeat-entry dm-columns" style="display:none;">';
            if( editKeys ){
                entry += '<div class="left-col">';
                entry += '<input type="text" id="' + id + '_' + randID + '_key" name="' + id + '[][key]" placeholder="Post Capability" />';
                entry += '</div>';
                entry += '<div class="right-col">';
                entry += '<input type="text" id="' + id + '_' + randID + '_value" name="' + id + '[][value]" placeholder="User Capability" />';
                entry += '</div>';
            } else{
                entry += '<div class="single-col">';
                entry += '<input type="text" id="' + id + '_' + randID + '" name="' + id + '[]" />';
                entry += '</div>';
            }
            entry += '<button type="button" class="button remove-entry" data-role="remove-repeat-entry" data-target="#' + id + '_entry_' + randID + '" tabindex="-1">';
            entry += '<span class="dashicons dashicons-no"></span>';
            entry += '</button>';
            entry += '</div>';
        if( $( '#' + id + '_repeat .repeat-entry' ).length == 0 )
            $( '#' + id + '_repeat .no-entries' ).slideUp( 150 ).fadeOut( 150 );
        var el = $( entry );
        el.insertBefore( $( '#' + id + '_repeat .no-entries' ).last( ) );
        el.slideDown( 150 );
        el.find( '[data-role=remove-repeat-entry]' ).on( 'click', removeEntry );
        el.find( '[type=text]' ).first( ).focus( );
    }

    var removeEntry = function( ){
        var remove = $( this );
        var entry = $( remove.attr( 'data-target' ) );
        entry.slideUp( 150, completeRemove );
        if( entry.parent( ).find( '.repeat-entry' ).length == 1 )
            entry.parent( ).find( '.no-entries' ).slideDown( 150 ).fadeIn( 150 );
    }

    var completeRemove = function( ){
        $( this ).remove( );
    }

    $( document ).ready( load );
} )( jQuery );

// Post Type Manager
( function( $ ){
    var canUpdate = false;
    var updated = false;
    var load = function( ){
        var slug = $( '#dmptm_slug' );
        if( slug.length > 0 ){
            $( '#title' ).on( 'keyup', updateSlug ).on( 'blur', function( ){ canUpdate = ( canUpdate && !updated ); } );
            slug.on( 'change', slugChanged );
            canUpdate = ( slug.val( ) == undefined || slug.val( ).length == 0 );
            $( '#dmptm_list_on' ).on( 'change', updateListOptions );
            updateListOptions( );
            $( 'a[data-icon]' ).on( 'click', changeIcon );
            $( '#dmptm_menu_icon' ).on( 'keyup', updateIconMatches )
                                   .on( 'focus', showDashIcons )
                                   .on( 'blur',  hideDashIcons );
            updateIconMatches( );
        }
    }

    var changeIcon = function( ){
        var $a = $( this );
        $( '#dmptm_menu_icon' ).val( $a.attr( 'data-icon' ) );
    }

    var hideDashIcons = function( ){
        $( '#dashicons-list' ).hide( );
    }

    var showDashIcons = function( ){
        $( '#dashicons-list' ).show( );
    }

    var updateIconMatches = function( ){
        var $input = $( '#dmptm_menu_icon' );
        var val = $input.val( ).split( '-' );
        var reg = '';
        for( var i=0; i<val.length; i++ ){
            if( val[ i ].length > 0 ){
                if( reg.length > 0 )
                    reg += '|';
                reg += val[ i ];
            }
        }
        reg = new RegExp( reg );
        $( 'a[data-icon]' ).each( function( ){
            var $a = $( this );
            var icon = $a.attr( 'data-icon' ).substring( 10 );
            if( val == '' || icon.match( reg ) )
                $a.show( );
            else
                $a.hide( );
        } );
    }

    var updateListOptions = function( ){
        var select = $( '#dmptm_list_on' );
        if( select.val( ) > 0 ){
            $( '#dmptm_show_on' ).parents( 'tr' ).show( );
            $( '#dmptm_posts_per_page' ).parents( 'tr' ).show( );
        } else{
            $( '#dmptm_show_on' ).parents( 'tr' ).hide( );
            $( '#dmptm_posts_per_page' ).parents( 'tr' ).hide( );
        }
    }

    var updateSlug = function( ){
        var slug = $( '#dmptm_slug' );
        if( canUpdate ){
            slug.val( $( this ).val( ).toLowerCase( ).replace( /[^a-z0-9]+/g, '_' ).replace( /(^_)|(_$)/g, '' ) );
            updated = true;
        }
    }

    var slugChanged = function( ){
        if( $( this ).val( ).length == 0 )
            canUpdate = true;
    }

    $( document ).ready( load );
} )( jQuery );

// Setup the tabber if this is a page with dm tabs.
( function( $ ){
    var tabber;

    var load = function( ){
        tabber = new DM_AdminTabs( dm_tabs[ 0 ] );
    }

    if( typeof dm_tabs !== 'undefined' && dm_tabs.length > 0 )
        $( document ).ready( load );
} )( jQuery );

// A tabbing object that relies on the url to determine which tab to display. It
// uses history.pushState to change the url and update the history and it
// listens to the popstate event to switch tabs as the history is moved through.
DM_AdminTabs = function( defaultTab ){
    this.defaultTab = defaultTab;

    // If the browser supports history state updates do page changes
    // dynamically from JS otherwise fall back to regular page loading.
    if( typeof history.pushState !== 'undefined' ){
        this.listenToHistory( );
        var _this = this;
        jQuery( '.dm-tabs .nav-tab' ).on( 'click', function( e ){
            var $tab = jQuery( this );
            var tab = _this.parseTab( $tab.attr( 'href' ) );
            e.preventDefault( );
            if( tab != _this.getCurrentTab( ) ){
                _this.switchToTab( tab );
            }
        } );
    }
}
DM_AdminTabs.prototype.getCurrentTab = function( ){
    return this.parseTab( location.search );
}
DM_AdminTabs.prototype.listenToHistory = function( ){
    jQuery( window ).on( 'popstate', this.updateFromHistory.bind( this ) );
}
DM_AdminTabs.prototype.parseTab = function( url ){
    var id = url.match( /tab=([a-zA-Z0-9\-\_]+)/ );
    // If the tab is not in the address use the default.
    if( id == null || id.length < 2 )
        return this.defaultTab;
    
    return id[ 1 ];
}
DM_AdminTabs.prototype.switchToTab = function( tabID, addToHistory ){
    var $tab = jQuery( '#dm-tab-' + tabID );
    if( $tab.length >= 0 ){
        if( addToHistory !== false ){
            var href = location.href;
            var search = location.search;
            var reg = /tab\=[a-zA-Z0-9\-\_]+/;
            if( href.search( /\?/ ) >= 0 )
                href = href.substr( 0, href.search( /\?/ ) );

            if( tabID == this.defaultTab ){
                search = search.replace( /\&?tab\=[a-zA-Z0-9\-\_]+/, '' )
            } else{
                if( search.search( reg ) == -1 ){
                    if( search.length == 0 )
                        search = '?';

                    if( search.length > 1 )
                        search += '&';

                    search += 'tab=' + tabID;
                } else{
                    search = search.replace( reg, 'tab=' + tabID );
                }
            }

            href += search;

            history.pushState( 'iws-admin-tabs', href, href );
        }
        
        var $active = jQuery( '.nav-tab.nav-tab-active' );
        $tab.addClass( 'nav-tab-active' );
        $active.removeClass( 'nav-tab-active' );

        var tab = new RegExp( '(^|[^a-zA-Z0-9\-\_]+)' + this.getCurrentTab( ) + '($|[^a-zA-Z0-9\-\_]+)' );
        jQuery( '[data-for-tab]' ).each( function( ){
            var $el = jQuery( this );
            if( $el.attr( 'data-for-tab' ).search( tab ) >= 0 )
                $el.delay( 5 ).show( );  // Delay so that everything is hidden before anything is shown
            else
                $el.hide( );
        } );
    }
}
DM_AdminTabs.prototype.updateFromHistory = function( e ){
    this.switchToTab( this.parseTab( location.search ), false );
}