( function( $ ){
    $( document ).ready( function( ){
        if( history.pushState != undefined ){
            // Save the starting markup for the update areas
            var state = { };
            state.updates = getUpdateAreas( );
            history.replaceState( state, state.url, state.url );

            setupLinks( $( 'body' ) );
        }
    } );

    $( window ).on( 'popstate', function( e ){
        if( e.originalEvent.state ){
            showHTML( e.originalEvent.state );
        }
    } );

    function getUpdateAreas( ){
        var areas = $( '[data-ajax]' );
        var updatables = [ ];
        for( var i=0; i<areas.length; i++ ){
            var area = areas.eq( i ).attr( 'data-ajax' );
            var markup = areas.eq( i ).html( );
            updatables.push( {
                area: area,
                markup: markup
            } );
        }

        return updatables;
    }

    function loadLink( e ){
        var $a = $( this );
        var href = $a.attr( 'href' );

        $.ajax( {
            url: href,
            data: { 'ajax-loader': 1 },
            method: 'POST',
            dataType: 'json',
            success: function( resp ){
                var state = { };
                state.updates = resp;
                showHTML( state );
                history.pushState( state, href, href );
            },
            error: function( ){
                // If we encounter an error rather than try and figure out what
                // to do just load the page so that the server can figure out
                // what to do instead.
                history.pushState( { }, href, href );
                location.replace( href );
            }
        } );

        e.preventDefault( );
    }

    function setupLinks( $parent ){
        $parent.find( 'a[href]' ).each( function( ){
            var $a = $( this );
            var href = $a.attr( 'href' );

            var isAdmin = href.search( 'wp-admin' ) >= 0;
            var isAnchor = href.length > 0 && href[ 0 ] == '#';
            var isExternalSite = $a.prop( 'hostname' ) != location.hostname;
            var isAdminBar = $a.parents( '#wpadminbar' ).length > 0;

            if( !isAdmin && !isAnchor && !isExternalSite && !isAdminBar )
                $a.on( 'click', loadLink );
        } );
    }

    function showHTML( data ){
        for( var i=0; i<data.updates.length; i++ ){
            var update = data.updates[ i ];
            var $area = $( '[data-ajax=' + update.area + ']' );
            if( update.title != undefined ){
                $( 'title' ).html( update.title );
            }
            else if( $area.html( ) != update.markup )
                updateArea( $area, update.markup );
        }
    }

    function updateArea( $area, markup ){
        $area.fadeOut( 400, function( ){
            $area.html( markup );
            setupLinks( $area );
            $area.fadeIn( );
        } );
    }
} )( jQuery );