<?php
    /**
     *  Module Name: DM AJAX Loader
     *  Version:     v1.0
     *  Description: A utility that loads page content via AJAX.
     *  Author:      Distill Mill LLC
     *  Author URI:  http://distillmill.com
     */

    class DM_AJAXLoader{
        private static $instance;

        public static function getInstance( ){
            if( !isset( self::$instance ) ){
                self::$instance = new self;
                self::$instance->init( );
            }

            return self::$instance;
        }

        public static function call( $method ){
            return array( self::getInstance( ), $method );
        }

        public function init( ){
            // Load the JS necessary to override the links, manage the browser
            // history, and load the correct markup into the correct areas.
            add_action( 'wp_enqueue_scripts', self::call( 'enqueue' ) );
            
            // If we are handling an ajax-loader request register the necessary
            // filters.
            if( isset( $_POST[ 'ajax-loader' ] ) && $_POST[ 'ajax-loader' ] ){
                // Override the template engine and only build the parts needed.
                add_filter( 'dm_load_template', self::call( 'loadData' ) );
                // Prevent a status other than 200 OK so that jQuery gives our
                // JS the markup instead of an error.
                add_filter( 'status_header', self::call( 'setStatusHeader' ) );
            }
        }

        public function enqueue( ){
            wp_register_script( 'dm-ajax-loader', DM_UTILS_URL . '_dm-utils/resources/js/dm-ajax-loader.min.js', array( 'jquery' ), '100' );
            wp_enqueue_script( 'dm-ajax-loader' );
        }

        // Calls the appropriate template parts to build the response.
        public function loadData( $loaded ){
            $loaded = true;
            $updates = array( );
            if( apply_filters( 'dm_ajax_load_content', true ) ){
                ob_start( );
                DM_Template::getContent( );
                $content = ob_get_clean( );
                $updates[ ] = array( 'area'=>'content', 'markup'=>$content );
            }

            if( apply_filters( 'dm_ajax_load_sidebar', false ) ){
                ob_start( );
                DM_Template::getSidebar( );
                $content = ob_get_clean( );
                $updates[ ] = array( 'area'=>'sidebar', 'markup'=>$content );
            }

            if( apply_filters( 'dm_ajax_load_header', false ) ){
                ob_start( );
                DM_Template::getFooter( true );
                $content = ob_get_clean( );
                $updates[ ] = array( 'area'=>'header', 'markup'=>$content );
            }

            if( apply_filters( 'dm_ajax_load_footer', false ) ){
                ob_start( );
                DM_Template::getFooter( true );
                $content = ob_get_clean( );
                $updates[ ] = array( 'area'=>'footer', 'markup'=>$content );
            }

            $title = apply_filters( 'dm_ajax_load_title', wp_title( '&raquo;', false ) );
            $updates[ ] = array( 'title'=>$title );

            $updates = apply_filters( 'dm_ajax_load_updates', $updates );
            
            echo json_encode( $updates );

            return $loaded;
        }

        // Overrides all changes to the status header forcing 200 OK so that
        // when jQuery recieves the data it will pass the markup to our JS
        // instead of triggering the error callback.
        public function setStatusHeader( $status ){
            return 'HTTP/1.1 200 OK';
        }
    }

    add_action( 'dm_init', 'DM_AJAXLoader::getInstance' );
