<?php
    class DM_Widgets{
        private static $instance;
        private static $widgetTypes = array( );

        public static function getInstance( ){
            if( !self::$instance )
                self::$instance = new self;

            return self::$instance;
        }

        public static function getGlobalWidgets( ){
            $query = new WP_Query( array( 'post_type' => 'widget', 'meta_key' => 'global', 'meta_value' => true ) );
            $widgets = array( );
            foreach( $query->posts as $widget ){
                $widgets[ ] = self::getWidget( $widget );
            }
            return $widgets;
        }

        public static function getPageWidgets( $post = null ){
            $id = self::getPostID( $post );
            $widgets = array( );
            if( DM()->getField( 'widgets', $id ) ){
                foreach( DM()->getField( 'widgets', $id ) as $widget ){
                    $widgets[ ] = self::getWidget( $widget );
                }
            }
            return ( $widgets ? $widgets : self::getGlobalWidgets( ) );
        }

        public static function getWidget( $widget = null ){
            $id = self::getPostID( $widget );
            $w = null;
            switch( DM()->getField( 'widget_type', $id ) ){
                case 'page':
                    $w = new DM_WidgetPage( $widget );
                    break;
                case 'post':
                    $w = new DM_WidgetPost( $widget );
                    break;
                case 'service':
                    $w = new DM_WidgetService( $widget );
                    break;
                case 'clinic':
                    $w = new DM_WidgetClinic( $widget );
                    break;
                case 'gallery':
                    $w = new DM_WidgetGallery( $widget );
                    break;
                case 'custom':
                    $w = new DM_WidgetCustom( $widget );
                    break;
                default:
                    // Must be a custom type.
                    $w = apply_filters( 'dm_widget_get_' . DM()->getField( 'widget_type', $id ), null, $widget );

            }

            return $w;
        }

        public static function addWidgetType( $type, $name ){
            self::$widgetTypes[ $type ] = $name;
        }

        public function __construct( ){
            add_filter( 'acf/load_field/name=widget_type', $this->call( 'loadWidgetTypes' ) );
        }

        public function loadWidgetTypes( $field ){
            $field[ 'choices' ] = array_merge( $field[ 'choices' ], self::$widgetTypes );
            return $field;
        }

        public function call( $method ){
            return array( $this, $method );
        }
    }

    class DM_Widget{
        protected $boxStyle = false;
        protected $global;
        protected $hideWidgetTitle = false;
        protected $name;
        protected $post;  // The custom post that is the widget.
        protected $type;

        public function __construct( $widget = null ){
            $this->post = $this->getPost( $widget );

            $this->name = $this->post->post_title;
            $this->global = DM()->getField( 'global', $this->getID( ) );
            $this->type = DM()->getField( 'widget_type', $this->getID( ) );
            
            $advanced = DM()->getField( 'widget_advanced', $this->getID( ) );
            if( $advanced ){
                foreach( $advanced as $option ){
                    switch( $option ){
                        case 'hide_title':
                            $this->hideWidgetTitle = true;
                            break;
                        case 'box_style':
                            $this->boxStyle = true;
                            break;
                    }
                }
            }

            $this->load( );
        }

        public function getID( ){
            return $this->post->ID;
        }

        public function getName( ){
            return $this->name;
        }

        public function getType( ){
            return $this->type;
        }

        public function isGlobal( ){
            return $this->global;
        }

        public function showingWidgetTitle( ){
            return !$this->hideWidgetTitle;
        }

        public function useBoxStyle( ){
            return $this->boxStyle;
        }
    }

    class DM_WidgetPage extends DM_Widget{
        protected $limit = -1;
        protected $pages = array( );
        protected $recents = false;

        protected function load( ){
            $this->recents = DM()->getField( 'show_recent', $this->getID( ) );
            $this->limit = DM()->getField( 'limit', $this->getID( ) );

            if( $this->isRecents( ) ){
                $query = new WP_Query( array( 'post_type'=>'page', 'status'=>'publish', 'posts_per_page'=>$this->getLimit( ) ) );
                foreach( $query->posts as $post ){
                    $this->pages[ ] = $post;
                }
            } else{
                foreach( DM()->getField( 'page', $this->getID( ) ) as $page ){
                    $this->pages[ ] = get_post( $page );
                }
            }
        }

        public function getLimit( ){
            if( $this->isRecents( ) )
                return $this->limit;

            return -1;
        }

        public function getPages( ){
            return $this->pages;
        }

        public function hasPages( ){
            return count( $this->pages ) > 0;
        }

        public function isRecents( ){
            return $this->recents;
        }
    }

    class DM_WidgetPost extends DM_Widget{
        protected $limit = -1;
        protected $posts = array( );
        protected $recents = false;

        protected function load( ){
            $this->recents = DM()->getField( 'show_recent', $this->getID( ) );
            $this->limit = DM()->getField( 'limit', $this->getID( ) );

            if( $this->isRecents( ) ){
                $query = new WP_Query( array( 'post_type'=>'post', 'status'=>'publish', 'posts_per_page'=>$this->getLimit( ) ) );
                foreach( $query->posts as $post ){
                    $this->posts[ ] = $post;
                }
            } else{
                foreach( DM()->getField( 'news', $this->getID( ) ) as $post ){
                    $this->posts[ ] = get_post( $post );
                }
            }
        }

        public function getLimit( ){
            if( $this->isRecents( ) )
                return $this->limit;

            return -1;
        }

        public function getPosts( ){
            return $this->posts;
        }

        public function hasPosts( ){
            return count( $this->posts ) > 0;
        }

        public function isRecents( ){
            return $this->recents;
        }
    }

    class DM_WidgetService extends DM_Widget{
        protected $limit = -1;
        protected $services = array( );
        protected $recents = false;

        protected function load( ){
            $this->recents = DM()->getField( 'show_recent', $this->getID( ) );
            $this->limit = DM()->getField( 'limit', $this->getID( ) );

            if( $this->isRecents( ) ){
                $query = new WP_Query( array( 'post_type'=>'service', 'status'=>'publish', 'posts_per_page'=>$this->getLimit( ) ) );
                foreach( $query->posts as $post ){
                    $this->services[ ] = $post;
                }
            } else{
                foreach( DM()->getField( 'service', $this->getID( ) ) as $service ){
                    $this->services[ ] = get_post( $service );
                }
            }
        }

        public function getLimit( ){
            if( $this->isRecents( ) )
                return $this->limit;

            return -1;
        }

        public function getServices( ){
            return $this->services;
        }

        public function hasServices( ){
            return count( $this->services ) > 0;
        }

        public function isRecents( ){
            return $this->recents;
        }
    }

    class DM_WidgetClinic extends DM_Widget{
        protected $limit = -1;
        protected $clinics = array( );
        protected $recents = false;

        protected function load( ){
            $this->recents = DM()->getField( 'show_recent', $this->getID( ) );
            $this->limit = DM()->getField( 'limit', $this->getID( ) );

            if( $this->isRecents( ) ){
                $query = new WP_Query( array( 'post_type'=>'clinic', 'status'=>'publish', 'posts_per_page'=>$this->getLimit( ) ) );
                foreach( $query->posts as $post ){
                    $this->clinics[ ] = new GAH_Clinic( $post );
                }
            } else{
                foreach( DM()->getField( 'clinic', $this->getID( ) ) as $clinic ){
                    $this->clinics[ ] = new GAH_Clinic( $clinic );
                }
            }
        }

        public function getLimit( ){
            if( $this->isRecents( ) )
                return $this->limit;

            return -1;
        }

        public function getClinics( ){
            return $this->clinics;
        }

        public function hasClinics( ){
            return count( $this->clinics ) > 0;
        }

        public function isRecents( ){
            return $this->recents;
        }
    }

    class DM_WidgetGallery extends DM_Widget{
        protected $captionsShown = true;
        protected $content;
        protected $controlsShown = true;
        protected $index = 0;
        protected $indicatorsShown = true;
        protected $slides = array( );
        protected $titlesShown = true;

        protected function load( ){
            foreach( DM()->getField( 'gallery', $this->getID( ) ) as $index => $slide ){
                $this->slides[ ] = new DM_GallerySlide( $slide, $index );
            }

            $this->content = DM()->getField( 'content', $this->getID( ) );

            $advanced = DM()->getField( 'gallery_advanced', $this->getID( ) );
            if( $advanced ){
                foreach( $advanced as $option ){
                    switch ( $option ) {
                        case 'hide_captions':
                            $this->captionsShown = false;
                            break;
                        case 'hide_controls':
                            $this->controlsShown = false;
                            break;
                        case 'hide_indicators':
                            $this->indicatorsShown = false;
                            break;
                        case 'hide_titles':
                            $this->titlesShown = false;
                            break;
                    }
                }
            }
        }

        public function getContent( ){
            return $this->content;
        }

        public function getNextSlide( ){
            $slide = null;
            if( $this->index < $this->getNumSlides( ) ){
                $slide = $this->slides[ $this->index ];
                $this->index++;
            }
            return $slide;
        }

        public function getNumSlides( ){
            return count( $this->slides );
        }

        public function getSlides( ){
            return $this->slides;
        }

        public function hasSlides( ){
            return count( $this->slides ) > 0;
        }

        public function resetSlides( ){
            $this->index = 0;
        }

        public function showingCaptions( ){
            return $this->captionsShown;
        }

        public function showingControls( ){
            return $this->controlsShown;
        }

        public function showingIndicators( ){
            return $this->indicatorsShown;
        }

        public function showingTitles( ){
            return $this->titlesShown;
        }
    }

    class DM_WidgetCustom extends DM_Widget{
        protected $content;
        protected $image;
        protected $title;

        protected function load( ){
            $this->content = DM()->getField( 'content', $this->getID( ) );
            $this->image = DM()->getField( 'image', $this->getID( ) );
            $this->title = DM()->getField( 'title', $this->getID( ) );
        }

        public function getContent( ){
            return $this->content;
        }

        public function getImage( $width = null, $height = null, $anchor = null ){
            $image = $this->image[ 'url' ];
            $image = DM( )->sizeImage( $image, $width, $height, $anchor );

            return $image;
        }

        public function getTitle( ){
            return $this->title;
        }
    }

    add_action( 'dm_init', 'DM_Widgets::getInstance' );
