<?php
    /**
     *  Module Name: DM Endpoints
     *  Version:     v1.0
     *  Description: A utility that attempts to allow sites to have a front end AJAX API.
     *  Author:      Distill Mill LLC
     *  Author URI:  http://distillmill.com
     */

    class DM_Endpoints{
        private static $instance;
        
        public static function getInstance( ){
            if( !isset( self::$instance ) )
                self::$instance = new self;

            return self::$instance;
        }

        public function __construct( ){
            $this->handlers = array( );
            $this->response = array( 'error'=>-1, 'status'=>-1, 'message'=>'Loading...' );

            add_action( 'pre_get_posts', $this->call( 'modifyQuery' ), 1 );
            add_action( 'wp_loaded', $this->call( 'flushRewrites' ) );
        }

        public function modifyQuery( $query ){
            if( array_key_exists( 'ajax', $query->query ) ){
                $action = $query->query[ 'ajax' ];
                $this->response = array( 'error'=>0, 'status'=>0, 'message'=>'Processed handlers for action ' . $action );
                
                if( has_filter( 'dm_ajax_' . $action ) ){
                    do_action( 'dm_before_ajax' );
                    $this->response = apply_filters( 'dm_ajax_' . $action, $this->response );
                }
                else
                    $this->response = array( 'error'=>0, 'status'=>-1, 'message'=>'No handlers for action \'' . $action . '\' found.' );

                header( 'Content-Type: application/json' );  // Set the correct content-type
                wp_send_json( $this->response );  // Write the data to the response
                exit;  // Prevent anything else from happening
            } elseif( array_key_exists( 'endpoint', $query->query ) ){
                $action = $query->query[ 'endpoint' ];
                
                if( has_filter( 'dm_endpoint_' . $action ) ){
                    do_action( 'dm_before_ajax' );
                    $redirect = apply_filters( 'dm_endpoint_' . $action, wp_get_referer( ) );
                    wp_redirect( $redirect, $status );
                    exit;  // Prevent anything else from happening
                } else
                    $query->is_404 = true;  // Bomb because this may be visible to the user
            }
        }

        public function flushRewrites( ){
            add_rewrite_rule( 'dm-api/v1/ajax/([^/]+)/?$', 'index.php?ajax=$matches[1]', 'top' );
            add_rewrite_tag( '%ajax%', '([^&])' );

            add_rewrite_rule( 'dm-api/v1/endpoint/([^/]+)/?$', 'index.php?endpoint=$matches[1]', 'top' );
            add_rewrite_tag( '%endpoint%', '([^&])' );
            
            $rules = get_option( 'rewrite_rules' );
            if( $rules && ( !array_key_exists( 'dm-api/v1/ajax/([^/]+)/?$', $rules ) || !array_key_exists( 'dm-api/v1/endpoint/([^/]+)/?$', $rules ) ) ){
                global $wp_rewrite;
                $wp_rewrite->flush_rules( );
            }
        }

        public function call( $method ){
            return array( $this, $method );
        }
    }

    function getEndpointURL( $endpoint ){
        return '/dm-api/v1/endpoint/' . $endpoint;
    }

    function getAjaxURL( $endpoint ){
        return '/dm-api/v1/ajax/' . $endpoint;
    }

    add_action( 'dm_init', 'DM_Endpoints::getInstance', 100 );