<?php
    // exit if accessed directly
    if ( !defined( 'ABSPATH' ) )
        die( );

    if( !current_user_can( 'manage_options' ) )
        wp_die( __( 'Invalid request', 'dm-utils-admin' ) );
?>
<div class="wrap dm-tabs">
    <?php screen_icon(); ?>
    <h2><?php echo esc_html( get_admin_page_title( ) ); ?></h2>
    <h2 class="nav-tab-wrapper">
        <?php
            $url = admin_url( 'index.php?page=dm_utils_admin_pages' );
            $tabs = DM( )->admin->getUtilsTabs( );
            $current = DM( )->admin->getCurrentUtilsTab( );
            $saveFor = array( );
            foreach( $tabs as $slug=>$tab ){
                $active = '';
                if( $current == $slug )
                    $active = ' nav-tab-active';
                $link = $url . '&tab=' . esc_attr( $slug );
                echo '<a href="' . esc_url( $link ) . '" id="dm-tab-' . $slug . '"';
                echo 'class="nav-tab' . $active . '">' . esc_html( $tab[ 'label' ] ) . '</a>';

                if( $tab[ 'save' ] )
                    $saveFor[ ] = $slug;
            }
        ?>
    </h2>
    <form name="dm-admin" method="post">
        <?php wp_nonce_field( 'update_dm_utils_settings', 'dm_utils' ); ?>
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="postbox-container-1" class="postbox-container">
                    <div class="postbox dm-meta-box no-move<?php if( !in_array( $current, $saveFor ) ) echo ' hidden'; ?>"
                         data-for-tab="<?php echo implode( ' ', $saveFor ); ?>">
                        <h3 class="hndle"><span>Save Updates</span></h3>
                        <div class="inside">
                            <input type="submit" class="button button-primary" value="Update" />
                        </div>
                    </div>
                    <?php DM( )->admin->doTabMetaBoxes( 'side', $current ); ?>
                </div> <!-- #postbox-container-1 -->
                <div id="postbox-container-2" class="postbox-container">
                    <?php
                        DM( )->admin->doTabMetaBoxes( 'normal', $current );
                        DM( )->admin->doTabMetaBoxes( 'advanced', $current );
                    ?>
                </div> <!-- #postbox-container-2 -->
            </div> <!-- #post-body -->
        </div> <!-- #poststuff -->
    </form>
</div><!-- .wrap -->
