<?php
    /**
     *  Module Name: DM Options
     *  Version:     v1.0
     *  Description: A utility to simplify access to options.
     *  Author:      Distill Mill LLC
     *  Author URI:  http://distillmill.com
     */

    class DM_Options{
        private static $coreKey;
        private static $instance;
        private static $instantiating = false;

        public static function getInstance( $dm=null, $coreKey=null ){
            if( !isset( self::$instance ) && !self::$instantiating ){
                self::$instantiating = true;
                self::$coreKey = $coreKey;
                self::$instance = new self;
                self::$instantiating = false;
            }

            return self::$instance;
        }

        // A fancy method to allow for easily providing any public method of this
        // class as a callback. It works by ensuring that there is an instance then
        // passing a reference to that instance. It is necessary to pass a reference
        // because if this method is called while the constructor is running there
        // will not be an instance.
        // NOTE: This does not call the method it just provides a valid callback.
        public static function call( $method ){
            self::getInstance( );
            return array( &self::$instance, $method );
        }

        public function __construct( ){
            DM( )->registerMethod( 'getField', self::call( 'getField' ) );
        }

        public function getField( /* variable number of arguments */ ){
            $args = func_get_args( );
            return DM( )->safeCallArray( 'get_field', $args );
        }
    }

    add_action( 'dm_init', 'DM_Options::getInstance', 10, 2 );