<?php
    // Update 20180205 - strip out year and classification per Davids request

    if( class_exists( 'DM_Theme' ) ){
        class DM_ProductTypes extends DM_Theme{
            public function __construct( ){
                DM( )->registerTheme( 'productTypes', $this );

                // add_action( 'init', $this->call( 'registerTaxonomy' ) );
                add_action( 'save_post', $this->call( 'savePost' ) );
                // add_filter( 'the_posts', $this->call( 'orderByYear' ), 100, 2 );
                // add_action( 'pre_get_posts', $this->call( 'orderByYearMeta' ) );
                add_action( 'admin_enqueue_scripts', self::call( 'enqueueScripts' ) );
                add_action( 'add_meta_boxes', self::call( 'removeDefaultMetaBox' ), 1000 );
            }

            public function displayMetaBox( ){
                $terms = get_terms( 'dm_product_type', array( 'hide_empty'=>false, 'parent'=>0, 'orderby'=>'term_order' ) );
                // echo '<tr>';
                // echo '<td class="left">';
                // echo '<label for="dm-classification">Classification</label>';
                // echo '</td>';
                // echo '<td class="right">';
                // if( $terms ){
                //     echo '<select id="dm-classification" name="product_classification">';
                //     foreach( $terms as $term ){
                //         echo '<option value="' . $term->term_id . '"';
                //         if( has_term( $term->term_id, 'dm_product_type' ) )
                //             echo ' selected';
                //         echo '>';
                //         echo $term->name;
                //         echo '</option>';
                //     }
                //     echo '</select>';
                // } else
                //     echo '<a href="' . admin_url( 'edit-tags.php?taxonomy=dm_product_type&post_type=product' ) . '">Create New Product Types</a>';
                // echo '</td>';
                // echo '</tr>';

                global $post;
                $terms = wp_get_post_terms( $post->ID, 'dm_product_type' );
                // $year = date( "Y" );
                // foreach( $terms as $term ){
                //     if( $term->parent !== 0 ){
                //         $year = $term->name;
                //         break;
                //     }
                // }
                // echo '<tr>';
                // echo '<td class="left">';
                // echo '<label for="dm-year">Year</label>';
                // echo '</td>';
                // echo '<td class="right">';
                // echo '<input type="number" id="dm-year" name="dm-product-year" value="' . $year . '" />';
                // echo '</td>';
                // echo '</tr>';

                $available = DM( )->getField( 'dm-language', 'option' );
                if( !$available ) $available = array( );
                $languages = get_post_meta( $post->ID, 'dm-languages', true );
                if( !$languages ) $languages = array( );
                echo '<tr>';
                echo '<td class="left">';
                echo '<label for="dm-year">Languages</label>';
                echo '</td>';
                echo '<td class="right">';
                if( $available ){
                    echo '<ul>';
                    foreach( $available as $language ){
                        echo '<label>';
                        echo '<input type="checkbox" name="dm-languages[]" value="' . $language[ 'code' ] . '"';
                        if( in_array( $language[ 'code' ], $languages ) )
                            echo ' checked';
                        echo ' /> ';
                        echo '<img src="' . DM( )->theme->sizeImage( $language[ 'flag' ][ 'url' ], 20 ) . '" style="border:1px solid #ddd;" /> ';
                        echo $language[ 'name' ];
                        echo '<br />';
                        echo '</label>';
                    }
                    echo '</ul>';
                }
                echo '<a href="' . admin_url( 'admin.php?page=acf-options' ) . '">Add More Languages</a>';
                echo '</td>';
                echo '</tr>';
            }

            public function enqueueScripts( $hook ){
                $screen = get_current_screen( );
                if( $screen->base == 'post' && $screen->post_type == 'product' ){
                    wp_enqueue_style( 'dm_admin_css' );
                    wp_enqueue_script( 'dm_admin_js' );
                }
            }

            public function getCurrentType( ){
                $obj = get_queried_object( );
                if( is_a( $obj, 'WP_Post' ) ){
                    $terms = wp_get_post_terms( $obj->ID, 'dm_product_type' );
                    foreach( $terms as $term ){
                        if( $term->parent === 0 )
                            return $term;
                    }
                } else{
                    echo '<div style="position:relative;z-index:100;top:250px;">';
                    vd( $obj );
                    echo '</div>';
                }
            }

            public function getProducts( $productType, $limit=-1, $exclude=null, $field='slug' ){
                $args = array(
                    'post_type'         => 'product',
                    'posts_per_page'    => $limit,
                    'tax_query'         => array(
                        array(
                            'taxonomy'  => 'dm_product_type',
                            'field'     => $field,
                            'terms'     => array( $productType )
                        )
                    )
                );
                if( $exclude )
                    $args[ 'post__not_in' ] = ( is_array( $exclude ) ? $exclude : array( $exclude ) );

                $posts = new WP_Query( $args );

                return $posts;
            }

            public function orderByYear( $posts, $query ){
                if( $query->is_main_query( ) ){
                    if( $query->is_tax && $query->is_archive ){
                        if( $query->get( 'dm_product_type' ) ){
                            foreach( $posts as $post ){
                                $terms = wp_get_post_terms( $post->ID, 'dm_product_type' );
                                $year = intval( date( 'Y' ) );
                                foreach( $terms as $term ){
                                    if( $terms->parent !== 0 ){
                                        $year = intval( $term->name );
                                        break;
                                    }
                                }
                                $post->year = $year;
                            }

                            usort( $posts, $this->call( 'sortByYear' ) );
                        }
                    }
                }

                return $posts;
            }

            public function orderByYearMeta( $query ){
                if( $query->is_main_query( ) ){
                    if( $query->is_tax && $query->is_archive ){
                        if( $query->get( 'dm_product_type' ) ){
                            $query->set( 'orderby', 'meta_value' );
                            $query->set( 'meta_key', 'dm-product-year' );
                            $query->set( 'order', 'DESC' );
                        }
                    }
                }
            }

            public function registerTaxonomy( ){
                register_taxonomy(
                    'dm_product_type',
                    'product',
                    array(
                        'label' => 'Classifications',
                        array(
                            'all_items'     => 'Classifications',
                            'name'          => 'Product Classifications',
                            'singular_name' => 'Product Classification'
                        ),
                        'public' => true,
                        'hierarchical' => true,
                        'meta_box_cb' => $this->call( 'displayMetaBox' ),
                        'rewrite' => array(
                            'slug' => 'classification',
                            'with_front' => false
                        )
                    )
                );
            }

            public function removeDefaultMetaBox( ){
                remove_meta_box( 'dm_product_typediv', 'product', 'side' );
            }

            public function savePost( $postID ){
                if( wp_is_post_revision( $postID ) )
                    return;

                $post = get_post( $postID );
                if( $post && $post->post_type == 'product' ){
                    $terms = array( intval( $_POST[ 'product_classification' ] ) );
                    // $children = get_terms(
                    //     'dm_product_type',
                    //     array(
                    //         'parent' => $terms[ 0 ],
                    //         'hide_empty' => false,
                    //         'name' => $_POST[ 'dm-product-year' ]
                    //     )
                    // );

                    if( $children ){
                        $terms[ ] = $children[ 0 ]->term_id;
                        update_post_meta( $post->ID, 'dm-product-year', $children[ 0 ]->name );
                    } else{
                        // $term = wp_insert_term(
                        //     $_POST[ 'dm-product-year' ],
                        //     'dm_product_type',
                        //     array( 'parent' => $terms[ 0 ] )
                        // );
                        $terms[ ] = $term[ 'term_id' ];
                        update_post_meta( $post->ID, 'dm-product-year', $term->name );
                    }

                    wp_set_post_terms( $post->ID, implode( ',', $terms ), 'dm_product_type' );
                }

                if( isset( $_POST[ 'dm-languages' ] ) )
                    update_post_meta( $post->ID, 'dm-languages', $_POST[ 'dm-languages' ] );
                else
                    update_post_meta( $post->ID, 'dm-languages', array( ) );
            }

            public function sortByYear( $postA, $postB ){
                if( $postA->year == $postB->year ) return 0;
                return $postA->year < $postB->year;
            }
        }
    }
