<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

?>

<?php
    global $product;
    /**
     * woocommerce_before_single_product hook
     *
     * @hooked wc_print_notices - 10
     */
     do_action( 'woocommerce_before_single_product' );

     if ( post_password_required() ) {
        echo get_the_password_form();
        return;
     }
?>

<div class="row">
    <div class="col-sm-8 col-md-9">
        <div itemscope itemtype="<?php echo woocommerce_get_product_schema(); ?>" id="product-<?php the_ID(); ?>" <?php post_class(); ?>>

            <?php
                /**
                 * woocommerce_before_single_product_summary hook
                 *
                 * @hooked woocommerce_show_product_sale_flash - 10
                 * @hooked woocommerce_show_product_images - 20
                 */
                do_action( 'woocommerce_before_single_product_summary' );
            ?>

            <div class="summary entry-summary">

                <?php
                    /**
                     * woocommerce_single_product_summary hook
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     */
                    do_action( 'woocommerce_single_product_summary' );
                ?>

            </div><!-- .summary -->
        </div>
        <?php do_action( 'woocommerce_after_single_product' ); ?>
    </div>
    <div class="col-xs-12 col-sm-4 col-md-3 pull-right">
        <?php
            woocommerce_template_single_price( );
            woocommerce_template_single_add_to_cart( );

            if( !$product->get_price_html( ) ){
                echo '<p class="price"><span>Not Available</span></p>';
            }
        ?>
    </div>
    <div class="col-sm-8 col-md-9 product-info">
        <?php
            /**
             * woocommerce_after_single_product_summary hook
             *
             * @hooked woocommerce_output_product_data_tabs - 10
             * @hooked woocommerce_upsell_display - 15
             * @hooked woocommerce_output_related_products - 20
             */
            do_action( 'woocommerce_after_single_product_summary' );
        ?>

        <meta itemprop="url" content="<?php the_permalink(); ?>" />

    </div><!-- #product-<?php the_ID(); ?> -->

    <div class="col-sm-4 col-md-3">
        <?php
            $terms = wp_get_post_terms( get_the_ID( ), 'dm_product_type' );
            if( $terms ){
                foreach( $terms as $term ){
                    if( $term->parent === 0 ){
                        $query = DM( )->productTypes->getProducts( $term->slug, 2, get_the_ID( ) );
                        if( $query->have_posts( ) ){
                            echo '<div class="related-products">';
                            echo '<h4>Related Products</h4>';
                            echo '<div class="product-type-products">';
                            echo '<div class="row">';
                            while( $query->have_posts( ) ){
                                $query->the_post( );

                                echo '<div class="col-xs-6 col-sm-12">';
                                get_template_part( 'part-product-preview' );
                                echo '</div>';
                            }
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        wp_reset_postdata( );
                        break;
                    }
                }
            }
        ?>
    </div>
</div>