<?php
    $brandImage = DM( )->getField( 'brand_image', 'option' );
?>
        <header id="main-header">
            <div class="container">
            <!-- Global Menus & Actions -->
                <div id="header-menus">
                    <nav id="site-nav" class="navbar navbar-default" role="navigation">
                        <div class="navbar-header">
                            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#primary-navigation">
                                <span class="sr-only">Toggle navigation</span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                            <a href="<?php echo get_home_url( ); ?>" class="navbar-brand">
                                <!-- Brand Image -->
                                <img src="<?php echo DM()->theme->sizeImage( $brandImage[ 'url' ], '', 100 ); ?>" class="brand-image"/>
                            </a>
                        </div>
                        <div class="collapse navbar-collapse" id="primary-navigation">
    <?php
        wp_nav_menu(
            array(
                'theme_location' => 'header_navigation',
                'menu_class' => 'nav navbar-nav',
                'depth' => 3
            )
        );
    ?>
                        </div>
                    </nav>
                </div> <!-- #header-menus -->
                <?php echo DM( )->theme->getCartWidget( ); ?>
            </div>
        </header><!-- /#main-header -->

        <?php
            $images = array( );
            if( is_page( ) || is_single( ) || DM( )->safeCall( 'is_product' ) ){
                if( DM( )->safeCall( 'is_product' ) ){
                    $pf = new WC_Product_Factory;
                    $product = $pf->get_product( get_queried_object( )->ID );
                    foreach( $product->get_gallery_attachment_ids( ) as $image ){
                        $images[ ] = array(
                            DM( )->theme->sizeImage( wp_get_attachment_url( $image ), null, 600 ),
                            DM( )->theme->sizeImage( wp_get_attachment_url( $image ), 50, 50 ),
                        );
                    }
                }
                if( !$images && DM( )->getField( 'gallery' ) ){
                    foreach( DM( )->getField( 'gallery' ) as $image ){
                        $images[ ] = array(
                            DM( )->theme->sizeImage( $image[ 'url' ], 1200, 600 ),
                            DM( )->theme->sizeImage( $image[ 'url' ], 50, 50 )
                        );
                    }
                }
                if( !$images ) $images[ ] = array( DM( )->theme->sizeImage( get_the_post_thumbnail_url( ), 1200, 600 ) );
            } elseif( DM( )->getField( 'placeholder_images', 'option' ) ){
                $placeholders = DM( )->getField( 'placeholder_images', 'option' );
                $default = null;
                $obj = get_queried_object( );
                foreach( $placeholders as $placeholder ){
                    if( $placeholder[ 'post_type' ] == 'default' )
                        $default = $placeholder[ 'image' ];
                    elseif( $placeholder[ 'post_type' ] == $obj->slug ){
                        $images[ ] = array( DM( )->theme->sizeImage( $placeholder[ 'image' ][ 'url' ], 1200, 600 ) );
                        $default = null;
                        break;
                    }
                }
                if( $default )
                    $images[ ] = array( DM( )->theme->sizeImage( $image[ 'url' ], 1200, 600 ) );
            }
            if( $images ):
        ?>
        <div class="masthead">
            <div id="masthead-carousel" class="carousel slide<?php if( count( $images ) <= 1 ) echo ' single-slide'; ?>" data-ride="carousel">
                <!-- Indicators -->
                <?php if( count( $images ) > 1 ): ?>
                <div class="carousel-indicators-container">
                    <div class="container">
                        <ol class="carousel-indicators">
                            <?php
                                for( $i=0; $i<count( $images ); $i++ ){
                                    echo '<li data-target="#masthead-carousel" data-slide-to="' . $i . '"';
                                    if( $i == 0 )
                                        echo ' class="active"';
                                    echo '>';
                                    echo '<img src="' . $images[ $i ][ 1 ] . '" />';
                                    echo '</li>';
                                }
                            ?>
                        </ol>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <?php
                        for( $i=0; $i<count( $images ); $i++ ){
                            echo '<div class="item';
                            if( $i == 0 )
                                echo ' active';
                            echo '">';
                            echo '<img src="' . $images[ $i ][ 0 ] . '">';
                            echo '</div>';
                        }
                    ?>
                </div>

                <?php if( count( $images ) > 1 ): ?>
                <!-- Controls -->
                <a class="left carousel-control" href="#masthead-carousel" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
                </a>
                <a class="right carousel-control" href="#masthead-carousel" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
                </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
